#!/usr/bin/python
#OLEDにCO2濃度、温度、しきい値判定メッセージを表示

import RaspiOled.oled as oled;
from PIL import Image
from PIL import ImageDraw
from PIL import ImageFont

import sys
import time
import subprocess
args = sys.argv

str1 = sys.argv[1]
str2 = sys.argv[2]
str3 = " " + sys.argv[3]

#表示開始数、スリープ時間
numDisp=3
numSleep=2

image = Image.new('1',oled.size)  # make 128x64 bitmap image
draw  = ImageDraw.Draw(image)

#フォント設定
f10 = ImageFont.truetype(font='/usr/share/fonts/truetype/freefont/FreeMono.ttf',size=12)
f20 = ImageFont.truetype(font='/usr/share/fonts/truetype/freefont/FreeSerif.ttf',size=20)
f25 = ImageFont.truetype(font='/usr/share/fonts/truetype/freefont/FreeSerif.ttf',size=25)
f30 = ImageFont.truetype(font='/usr/share/fonts/truetype/freefont/FreeSerif.ttf',size=30)
f80 = ImageFont.truetype(font='/usr/share/fonts/opentype/noto/NotoSansCJK-Light.ttc',size=80)
f20j = ImageFont.truetype(font='/usr/share/fonts/opentype/noto/NotoSansCJK-Light.ttc',size=20)
f30j = ImageFont.truetype(font='/usr/share/fonts/opentype/noto/NotoSansCJK-Light.ttc',size=30)

#入力文字列から不要な文字を削除
strCo2 =str2.replace('[ppm]', '')
strCo2 =strCo2.replace('↑', '')
strCo2 =strCo2.replace('↓', '')
strCo2 =strCo2.replace('null', '')
score =0
if len(strCo2) > 0:
  score =int(strCo2)
str4=""
str5=""
str40=""
str50=""
#CO2濃度閾値判定
if score >= 1000:
  str4="換気しよッ！！"
  str5="Q｡('-'｡)"
  str40="CO2濃度"
  str50="1000ppm以上"
  print('換気しよッ！！')
elif score >= 400:
  str4="正常で～す！！"
  str5="(*^-^*)"
  str40="CO2濃度"
  str50="1000ppm以下"
  print('正常です！！')
else:
  str4="測定中"
  str5="測定中"
  print('計測中')

#測定結果をループして表示
for i in range(2):
    #①時間とCO2
    image = Image.new('1',oled.size)  # make 128x64 bitmap image
    draw  = ImageDraw.Draw(image)
    draw.text((0, 0),str1, font=f20, fill=1)
    draw.text((0,26),str2, font=f30, fill=1)
    oled.begin()
    oled.image(image)
    print(str2)
    time.sleep(numDisp)

    #消灯①
    image = Image.new('1',oled.size)  # make 128x64 bitmap image
    draw  = ImageDraw.Draw(image)
    oled.begin()
    oled.image(image)
    print("消灯①")
    time.sleep(numSleep)

    #②時間と温度を表示
    image = Image.new('1',oled.size)  # make 128x64 bitmap image
    draw  = ImageDraw.Draw(image)
    draw.text((0, 0),str1, font=f20, fill=1)
    draw.text((0,26),str3, font=f25, fill=1)
    oled.begin()
    oled.image(image)
    print(str3)
    time.sleep(numDisp)

    #消灯②
    image = Image.new('1',oled.size)  # make 128x64 bitmap image
    draw  = ImageDraw.Draw(image)
    oled.begin()
    oled.image(image)
    print("消灯②")
    time.sleep(numSleep)

    #③CO2と温度を表示
    image = Image.new('1',oled.size)  # make 128x64 bitmap image
    draw  = ImageDraw.Draw(image)
    draw.text((0, 0),str2, font=f25, fill=1)
    draw.text((0,26),str3, font=f25, fill=1)
    oled.begin()
    oled.image(image)
    print(str2)
    print(str3)
    time.sleep(numDisp)

    #消灯③
    image = Image.new('1',oled.size)  # make 128x64 bitmap image
    draw  = ImageDraw.Draw(image)
    oled.begin()
    oled.image(image)
    print("消灯③")
    time.sleep(numSleep)

    #CO2濃度判定表示
    image = Image.new('1',oled.size)  # make 128x64 bitmap image
    draw  = ImageDraw.Draw(image)
    draw.text((0, 0),str40, font=f20j, fill=1)
    draw.text((0,26),str50, font=f20j, fill=1)
    oled.begin()
    oled.image(image)
    print("正常or異常判定")
    time.sleep(2)

    #⑤顔文字表示
    image = Image.new('1',oled.size)  # make 128x64 bitmap image
    draw  = ImageDraw.Draw(image)
    draw.text((0, 0),str4, font=f20j, fill=1)
    draw.text((0,26),str5, font=f30j, fill=1)
    oled.begin()
    oled.image(image)
    print("顔文字表示")
    time.sleep(3)

    #消灯④
    image = Image.new('1',oled.size)  # make 128x64 bitmap image
    draw  = ImageDraw.Draw(image)
    oled.begin()
    oled.image(image)
    print("消灯④")
    time.sleep(numSleep)

