#!/bin/sh
echo "hello worldMHZ_OLED_0602"


#出力ファイルの年月日、OLED画面表示の現在時刻を変数にセット
dateYMD=`date '+%Y-%m-%d %H:%M:%S'`
dateMD=`date '+%m/%d_%H:%M:%S'`
#１日分出力ログファイル名、直近20回ログファイル名
dayLogName=`date '+%Y-%m-%d.log'`
last20LogName=`date '+%Y-%m-%d_single.log'`

#CO2測定結果を取得
result2=`sudo python3 -m mh_z19 --all`
#測定結果からCO2、温度数値を取得
result_CO2=`echo $result2 | jq '.co2'`
result_Temp=`echo $result2 | jq '.temperature'`
#温度のセンサ個体差のずれを温度調整
result_TempOffset=$(($result_Temp-4))

#測定時間、CO2濃度、温度をログ出力
echo "${dateYMD},${result_CO2},${result_Temp}" >> "${dayLogName}"
#直近20回分をログ出力
tail "${dayLogName}" -n 20 >"${last20LogName}"

#Logファイルの直近５から１回分のファイルを出力
tail "${dayLogName}" -n 5 >"MHZ_Last5.log"
tail "${dayLogName}" -n 4 >"MHZ_Last4.log"
tail "${dayLogName}" -n 3 >"MHZ_Last3.log"
tail "${dayLogName}" -n 2 >"MHZ_Last2.log"
tail "${dayLogName}" -n 1 >"MHZ_Last1.log"

#直近５回を確認出力
cat MHZ_Last5.log

#直近５回の１行分のをファイル出力
head "MHZ_Last5.log" -n 1 >"MHZ_L5.log"
head "MHZ_Last4.log" -n 1 >"MHZ_L4.log"
head "MHZ_Last3.log" -n 1 >"MHZ_L3.log"
head "MHZ_Last2.log" -n 1 >"MHZ_L2.log"
head "MHZ_Last1.log" -n 1 >"MHZ_L1.log"

#１行ファイルを読み込んでカンマ区切りで分割してCO2結果を変数に取得
strDHT=`head MHZ_L1.log -n 1`
ARR=(${strDHT//,/ })
strL1=${ARR[2]}
strDHT=`head MHZ_L2.log -n 1`
ARR=(${strDHT//,/ })
strL2=${ARR[2]}
strDHT=`head MHZ_L3.log -n 1`
ARR=(${strDHT//,/ })
strL3=${ARR[2]}
strDHT=`head MHZ_L4.log -n 1`
ARR=(${strDHT//,/ })
strL4=${ARR[2]}
strDHT=`head MHZ_L5.log -n 1`
ARR=(${strDHT//,/ })
strL5=${ARR[2]}

#CO2の結果を1000ppm超過判定して5回分の判定を0or1の文字列結果にセット
#(1:超過、0:正常範囲内)
result5=`echo "$strL5>1000" | bc`
result5=$result5`echo "$strL4>1000" | bc`
result5=$result5`echo "$strL3>1000" | bc`
result5=$result5`echo "$strL2>1000" | bc`
result5=$result5`echo "$strL1>1000" | bc`
echo $result5


#CO2の測定結果と調整後の気温結果文字列を作成
#測定結果を1000ppmしきい値判定
result=`echo "$result_CO2>1000" | bc`
if [ $result -eq 1 ]; then
  echo "1000以上"
  result201="${result_CO2}[ppm]"
else
  echo "1000以下"
  result201="${result_CO2}[ppm]"
fi
#result202="${result_TempOffset}[℃]"
result202="${result_TempOffset}[℃](-4)"
echo ${dateMD} ${result201} ${result202}
#CO2センサ結果をOLEDを表示(時刻、CO2結果、気温結果)
python3 OLED_speak_text_0602.py ${dateMD} ${result201} ${result202}

