#!/bin/sh
echo "hello worldMHZ_OLED_QR_Buzzer_DHT3_0611"


#出力ファイルの年月日、OLED画面表示の現在時刻を変数にセット
dateYMD=`date '+%Y-%m-%d %H:%M:%S'`
dateMD=`date '+%m/%d_%H:%M:%S'`
#１日分出力ログファイル名、直近20回ログファイル名
dayLogName=`date '+%Y-%m-%d.log'`
last20LogName=`date '+%Y-%m-%d_single.log'`

#①CO2測定結果を取得
result2=`sudo python3 -m mh_z19 --all`
#測定結果からCO2、温度数値を取得
result_CO2=`echo $result2 | jq '.co2'`
result_Temp=`echo $result2 | jq '.temperature'`
#温度のセンサ個体差のずれを温度調整
result_TempOffset=$(($result_Temp-4))

#②測定時間、CO2濃度、温度をログ出力
echo "${dateYMD},${result_CO2},${result_Temp}" >> "${dayLogName}"
#直近20回分をログ出力
tail "${dayLogName}" -n 20 >"${last20LogName}"

#③Logファイルの直近５から１回分のファイルを出力
tail "${dayLogName}" -n 5 >"MHZ_Last5.log"
tail "${dayLogName}" -n 4 >"MHZ_Last4.log"
tail "${dayLogName}" -n 3 >"MHZ_Last3.log"
tail "${dayLogName}" -n 2 >"MHZ_Last2.log"
tail "${dayLogName}" -n 1 >"MHZ_Last1.log"

#直近５回を確認出力
cat MHZ_Last5.log

#④直近５回の１行分のをファイル出力
head "MHZ_Last5.log" -n 1 >"MHZ_L5.log"
head "MHZ_Last4.log" -n 1 >"MHZ_L4.log"
head "MHZ_Last3.log" -n 1 >"MHZ_L3.log"
head "MHZ_Last2.log" -n 1 >"MHZ_L2.log"
head "MHZ_Last1.log" -n 1 >"MHZ_L1.log"

#⑤１行ファイルを読み込んでカンマ区切りで分割してCO2結果を変数に取得
strDHT=`head MHZ_L1.log -n 1`
ARR=(${strDHT//,/ })
strL1=${ARR[2]}
strDHT=`head MHZ_L2.log -n 1`
ARR=(${strDHT//,/ })
strL2=${ARR[2]}
strDHT=`head MHZ_L3.log -n 1`
ARR=(${strDHT//,/ })
strL3=${ARR[2]}
strDHT=`head MHZ_L4.log -n 1`
ARR=(${strDHT//,/ })
strL4=${ARR[2]}
strDHT=`head MHZ_L5.log -n 1`
ARR=(${strDHT//,/ })
strL5=${ARR[2]}

#⑥CO2の結果を1000ppm超過判定して5回分の判定を0or1の文字列結果にセット
#(1:超過、0:正常範囲内)
result5=`echo "$strL5>1000" | bc`
result5=$result5`echo "$strL4>1000" | bc`
result5=$result5`echo "$strL3>1000" | bc`
result5=$result5`echo "$strL2>1000" | bc`
result5=$result5`echo "$strL1>1000" | bc`
echo $result5

#⑦正常なCO2濃度から1000ppm以上に変化した場合にアラームを鳴らす
#過去５回で初めて上限を超えた場合に鳴らす。「00001」
#上限を５回以上連続で超えた場合も鳴らす。　「11111」
if [ $result5 = "00001" -o $result5 = "11111" ];then
  echo "アラーム対象"
  python3 Buzzer_pin40_GPIO21_0602.py
else
  echo "アラーム対象外"
fi

#上限を５回以上連続で超えた場合も鳴らす。,「11111」
#if [ $result5 = "11111" ];then echo "アラーム対象";else echo "アラーム対象外";fi
#過去の４回で１回でも正常値の場合ならさない
#「1000」「0100」「0010」「0001」
#「1100」「0110」「0011」
#「1110」「0111」
#「1010」「1001」
#「1011」「1101」
#「0101」


#⑪DHT用の１日分出力ログファイル名、直近20回ログファイル名
dayDHT_LogName=`date '+%Y-%m-%dDHT.log'`
lastDHT_20LogName=`date '+%Y-%m-%dDHT_single.log'`
dayDHT2_LogName=`date '+%Y-%m-%dDHT2.log'`
lastDHT2_20LogName=`date '+%Y-%m-%dDHT2_single.log'`


echo "DHR11_Read_Start"
resultDHT=`python3 DHT11_Read_pin7_GPIO4.py`
echo "DHR11_Read_End"
resultDHT_Hum=`echo $resultDHT | jq '.Humidity'`
resultDHT_Temp=`echo $resultDHT | jq '.Temperature'`

echo "DHT_Hum:"$resultDHT_Hum
#温度湿度測定エラー対応
if [ `echo "$resultDHT_Hum < 1.0" | bc` == 1 ]; then
  echo "取得失敗[1]"
  sleep 2
  echo "DHR11_Read_Start"
  resultDHT=`python3 DHT11_Read_pin7_GPIO4.py`
  echo "DHR11_Read_End"
  resultDHT_Hum=`echo $resultDHT | jq '.Humidity'`
  resultDHT_Temp=`echo $resultDHT | jq '.Temperature'`
fi
if [ `echo "$resultDHT_Hum < 1.0" | bc` == 1 ]; then
  echo "取得失敗[2]"
  sleep 2
  echo "DHR11_Read_Start"
  resultDHT=`python3 DHT11_Read_pin7_GPIO4.py`
  echo "DHR11_Read_End"
  resultDHT_Hum=`echo $resultDHT | jq '.Humidity'`
  resultDHT_Temp=`echo $resultDHT | jq '.Temperature'`
fi
if [ `echo "$resultDHT_Hum < 1.0" | bc` == 1 ]; then
  echo "取得失敗[3]"
  sleep 2
  echo "DHR11_Read_Start"
  resultDHT=`python3 DHT11_Read_pin7_GPIO4.py`
  echo "DHR11_Read_End"
  resultDHT_Hum=`echo $resultDHT | jq '.Humidity'`
  resultDHT_Temp=`echo $resultDHT | jq '.Temperature'`
fi


#⑫DHT_測定時間、温度、湿度をログ出力
echo "${dateYMD},${resultDHT_Temp},${resultDHT_Hum}" >> "${dayDHT_LogName}"
#直近20回分をログ出力
tail "${dayDHT_LogName}" -n 20 >"${lastDHT_20LogName}"

#⑫DHT_測定時間、CO2濃度、温度、DHT温度、湿度をログ出力
echo "${dateYMD},${result_CO2},${result_Temp},${resultDHT_Temp},${resultDHT_Hum}" >> "${dayDHT2_LogName}"
#直近20回分をログ出力
tail "${dayDHT2_LogName}" -n 20 >"${lastDHT2_20LogName}"


#⑧CO2の測定結果と調整後の気温結果文字列を作成
#測定結果を1000ppmしきい値判定
result=`echo "$result_CO2>1000" | bc`
if [ $result -eq 1 ]; then
  echo "1000以上"
  result201="${result_CO2}[ppm]"
else
  echo "1000以下"
  result201="${result_CO2}[ppm]"
fi
#result202="${result_TempOffset}[℃]"
result202="${result_TempOffset}[℃](-4)"
echo ${dateMD} ${result201} ${result202}

#resultoff222=${resultDHT_Temp}

resultoff222=`echo $resultDHT_Temp - 6 | bc`


result222="${resultoff222}[℃](-6)"
result333="${resultDHT_Hum}[％]"

echo ${result222} ${result333}

#⑨CO2センサ結果をOLEDを表示(時刻、CO2結果、気温結果)
#python3 OLED_speak_text_0602.py ${dateMD} ${result201} ${result202}
python3 OLED_speak_text_0611.py ${dateMD} ${result201} ${result202} ${result222} ${result333} 11 22 33


#⑩QRコード説明文字とイメージを表示
#作成方法ページのQRコードをOLEDに表示
python3 OLED_text_2ROW_0602.py "作り方ページ" "URL" 1
python3 OLED_image_0602.py https_naname-45.com.png
sleep 4
#リアルタイムグラフ表示ページのQRコードをOLEDに表示
python3 OLED_text_2ROW_0602.py "CO2グラフ" "ページURL" 1
python3 OLED_image_0602.py http_raspberrypiw.local.png

