// 2) CSVから２次元配列に変換
function csv2Array(str) {
  var csvData = [];
  var lines = str.split("\n");
  for (var i = 0; i < lines.length; ++i) {
    var cells = lines[i].split(",");
    csvData.push(cells);
  }
  return csvData;
}

function drawBarChart(data) {
  // 3)chart.jsのdataset用の配列を用意
  var tmpLabels = [], tmpData1 = [], tmpData2 = [];
  for (var row in data) {
    //tmpLabels.push(data[row][0])
    tmpLabels.push(data[row][0].slice(0,16))
    tmpData1.push(data[row][1])
    tmpData2.push(data[row][2])
  };

  // 4)chart.jsで描画
  var ctx = document.getElementById("myChart").getContext("2d");
  var myChart = new Chart(ctx, {
    type: 'bar',
    data: {
      labels: tmpLabels,
      datasets: [
        { label: "Co2", data: tmpData1, backgroundColor: "red" },
        { label: "Temp", data: tmpData2, backgroundColor: "blue" }
      ]
    }
  });
}

function main() {
  // 1) ajaxでCSVファイルをロード
  var req = new XMLHttpRequest();
  
  //現在年月日をセット
  var dt = new Date();
  //XX日前
  dt.setDate(dt.getDate());

  var y = dt.getFullYear();
  var m = ('00' + (dt.getMonth()+1)).slice(-2);
  var d = ('00' + dt.getDate()).slice(-2);
  logDate = y + '-' + m + '-' + d + '.log';
  
  //var filePath = 'data.csv';
  //var filePath = '2021-02-26.log';
  var filePath = logDate;
  req.open("GET", filePath, true);
  req.onload = function() {
    var str = req.responseText;
    var lines = str.split("\n");
    var cells = lines[lines.length-2].split(",");
    //記録日時(YYYY-MM-DD)
    document.getElementById('myTime').innerHTML = cells[0].slice(0,10);
  
    // 2) CSVデータ変換の呼び出し
    data = csv2Array(req.responseText);
    // 3) chart.jsデータ準備、4) chart.js描画の呼び出し
    drawBarChart(data);
  }
  req.send(null);
}

main();
